<?php

/**
 * validatekey
 */
class validatekey
{

    public $pdo;

    /**
     * __construct
     *
     * @param  mixed $serverName
     * @param  mixed $DBname
     * @param  mixed $userName
     * @param  mixed $password
     * @return void
     */
    public function __construct($serverName, $DBname, $userName, $password)
    {
        $this->pdo = new PDO('mysql:host=' . $serverName . ';dbname=' . $DBname, $userName, $password);
    }


    /**
     * validateuser
     *
     * @param  mixed $username
     * @return userdetails
     */

    public function validateuser($username)
    {
        //change the query ----combaine with profile feilds
        $stmt = $this->pdo->prepare("SELECT u.id,u.username
        ,(SELECT d1.data FROM mdl_user_info_data d1
         JOIN mdl_user_info_field f1 ON d1.fieldid = f1.id AND f1.shortname = 'licensekey'
         WHERE d1.userid = u.id
        ) AS 'serialkey'
        ,(SELECT d1.data FROM mdl_user_info_data d1
         JOIN mdl_user_info_field f1 ON d1.fieldid = f1.id AND f1.shortname = 'status'
         WHERE d1.userid = u.id
        ) AS 'installstatus'       
        FROM mdl_user u where u.username = :username");
        $stmt->bindParam(":username", $username);
        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);

        return $result;
    }
  
    /**
     * updateinstallationstatus
     *
     * @param  mixed $uid
     * @return boolean
     */
    public function updateinstallationstatus($uid)
    {
        //change the query ----update with profile feilds
        $stmt = $this->pdo->prepare("UPDATE mdl_user_info_data SET DATA='Installed' WHERE userid = :userid AND fieldid = 16");
        $stmt->bindParam(":userid", $uid);
        $stmt->execute();
        return true;
    }

  
    /**
     * add machine details
     *
     * @param  mixed $uid
     * @return boolean
     */

    public function addMachinedetails($userid,$machine)
    {
        $stmt = $this->pdo->prepare("INSERT INTO mdl_flightgear (userid,machine) VALUES (:userid,:machine)");
        $stmt->bindParam(":userid", $userid);
        $stmt->bindParam(":machine", $machine);
        $stmt->execute();
        return true;
    }


    /**
     * add machine details
     *
     * @param  mixed $uid
     * @return boolean
     */

    public function getMachinedetails($userid)
    {
        $stmt = $this->pdo->prepare("SELECT machine FROM mdl_flightgear where userid=:userid");
        $stmt->bindParam(":userid", $userid);
        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_OBJ);
        return $result;
    }
}
